%Test BertiniLab solve method
function test_suite = testSolve %#ok<*STOUT>
initTestSuite;

% function testNoInputFile  %#ok<*DEFNU>
% obj = deleteBertiniInputFile;
% f = @() solve(obj);
% assertExceptionThrown(f,'BertiniLab:solve:callFailed')
% assertTrue(isempty(obj.solve_summary))
% 
% function testBadInputFile
% obj = makeBadBertiniInputFile;
% f = @() solve(obj);
% assertExceptionThrown(f,'BertiniLab:solve:callFailed')
% assertTrue(isempty(obj.solve_summary))

function testBasicExample %#ok<*DEFNU>
polysyms('x','y')
obj = BertiniLab('function_def',[x^2-1; x+y-1],'variable_group',[x y]);
obj = solve(obj);
assertTrue(~isempty(strfind(obj.solve_summary,'Paths Tracked: 2')))
real_finite_solutions = obj.read_solutions('real_finite_solutions');
assertElementsAlmostEqual(double(real_finite_solutions),[1 -1; 0 2],'absolute',1e-12)

function testBadInputFile
polysyms('x','y')
obj = BertiniLab('function_def',y,'variable_group',x);
f = @() obj.solve;
assertExceptionThrown(f,'BertiniLab:solve:callFailed')

function teardown
file_names = {'config','failed_paths','finite_solutions','func_input','input','main_data', ...
    'midpath_data','nonsingular_solutions','output','raw_data', ...
    'raw_solutions','real_finite_solutions','singular_solutions', ...
    'start'};
warning('off','MATLAB:DELETE:FileNotFound')
delete(file_names{:});
warning('on','MATLAB:DELETE:FileNotFound')

